%------------------------------------------------------------------------------
% File     : SEU562^2 : TPTP v7.4.0. Released v3.7.0.
% Domain   : Set Theory
% Problem  : Preliminary Notions - Relations on Sets - Subsets
% Version  : Especial > Reduced > Especial.
% English  : (! A:i.! B:i.(! x:i.in x A -> in x B) -> subset A B)

% Refs     : [Bro08] Brown (2008), Email to G. Sutcliffe
% Source   : [Bro08]
% Names    : ZFC064l [Bro08]

% Status   : Theorem
% Rating   : 0.00 v6.0.0, 0.14 v5.5.0, 0.17 v5.4.0, 0.20 v5.3.0, 0.40 v5.2.0, 0.20 v5.0.0, 0.40 v4.1.0, 0.00 v3.7.0
% Syntax   : Number of formulae    :    6 (   0 unit;   3 type;   2 defn)
%            Number of atoms       :   29 (   2 equality;  16 variable)
%            Maximal formula depth :    9 (   6 average)
%            Number of connectives :   22 (   0   ~;   0   |;   0   &;  16   @)
%                                         (   0 <=>;   6  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :    4 (   4   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    5 (   3   :;   0   =)
%            Number of variables   :    9 (   0 sgn;   7   !;   0   ?;   2   ^)
%                                         (   9   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : http://mathgate.info/detsetitem.php?id=151
%          : 
%------------------------------------------------------------------------------
thf(in_type,type,(
    in: $i > $i > $o )).

thf(subset_type,type,(
    subset: $i > $i > $o )).

thf(subset,definition,
    ( subset
    = ( ^ [A: $i,B: $i] :
        ! [Xx: $i] :
          ( ( in @ Xx @ A )
         => ( in @ Xx @ B ) ) ) )).

thf(subsetI1_type,type,(
    subsetI1: $o )).

thf(subsetI1,definition,
    ( subsetI1
    = ( ! [A: $i,B: $i] :
          ( ! [Xx: $i] :
              ( ( in @ Xx @ A )
             => ( in @ Xx @ B ) )
         => ( subset @ A @ B ) ) ) )).

thf(subsetI2,conjecture,
    ( subsetI1
   => ! [A: $i,B: $i] :
        ( ! [Xx: $i] :
            ( ( in @ Xx @ A )
           => ( in @ Xx @ B ) )
       => ( subset @ A @ B ) ) )).

%------------------------------------------------------------------------------
